if exist('REVS','var') && (REVS.verbose > 0)  disp(['Loading ' mfilename]); end

transmission_type               = enum_transmission_type.automatic;
transmission_thermal_type       = enum_transmission_thermal_type.constant_temperature;
transmission_lockup_select      = enum_transmission_lockup_select.uber_dynamic;

transmission                    = class_REVS_AT_transmission;
transmission.matrix_vintage     = enum_matrix_vintage.present;
transmission.name               = mfilename; 
transmission.rated_torque_Nm    = 250.00000; 

transmission.gear = class_REVS_gearbox;
transmission.gear.type                                  = enum_transmission_type.automatic;
transmission.gear.number                                = [    0.00000000,	   1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	 ]; 
transmission.gear.ratio                                 = [    0.00000000,	   4.1010000,	   2.6530000,	   1.7110000,	   1.2940000,	  0.89470000,	  0.66750000,	 ]; 
transmission.gear.inertia_kgm2                          = [    0.00000000,	 0.012500000,	 0.012500000,	 0.012500000,	 0.012500000,	 0.012500000,	 0.012500000,	 ]; 
transmission.gear.efficiency_norm.axis_1.breakpoints    = [    0.00000000,	   1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	 ]; 
transmission.gear.efficiency_norm.axis_1.signal         = 'gb_cmd_gear'; 
transmission.gear.efficiency_norm.table                 = [     1.0000000,	  0.95000000,	  0.91300000,	  0.97500000,	  0.96900000,	  0.98000000,	  0.96500000,	 ]; 
transmission.gear.common_input_inertia_kgm2             = 0.025000000; 
transmission.gear.common_output_inertia_kgm2            = 0.025000000;

transmission.gear.input_torque_loss_Nm.axis_1.breakpoints       = [    0.00000000,	   1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_1.signal            = 'gb_cmd_gear'; 
transmission.gear.input_torque_loss_Nm.axis_2.breakpoints       = [     52.359878,	   78.539816,	   104.71976,	   130.89969,	   157.07963,	   183.25957,	   209.43951,	   261.79939,	   314.15927,	   418.87902,	   523.59878,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_2.signal            = 'gb_spd_in_radps'; 
transmission.gear.input_torque_loss_Nm.axis_3.breakpoints       = [     5.0000000,	   10.000000,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_3.extrapolate_above = 1; 
transmission.gear.input_torque_loss_Nm.axis_3.extrapolate_below = 1; 
transmission.gear.input_torque_loss_Nm.axis_3.signal            = 'ctrl.gb_line_press_bar'; 
transmission.gear.input_torque_loss_Nm.axis_4.breakpoints       = [     37.000000,	   93.000000,	 ]; 
transmission.gear.input_torque_loss_Nm.axis_4.signal            = 'trans_temp_degC';
transmission.gear.input_torque_loss_Nm.table = [];
transmission.gear.input_torque_loss_Nm.table(:,:,1,1) = [
   1.5200000,    1.8200000,    1.6400000,    1.2400000,    1.0800000,    1.0700000,    1.1000000,    1.2600000,    1.3400000,    2.0700000,    2.8500000, ;
   1.5200000,    1.8200000,    1.6400000,    1.2400000,    1.0800000,    1.0700000,    1.1000000,    1.2600000,    1.3400000,    2.0700000,    2.8500000, ;
  0.00000000,   0.85000000,   0.84000000,    1.1300000,    1.3700000,    1.5200000,    1.6800000,    1.9900000,    2.3400000,    3.0400000,    4.0300000, ;
   2.0300000,    2.5500000,    2.4100000,    2.3900000,    2.5900000,    2.4500000,    2.5300000,    2.7800000,    3.2100000,    4.4600000,    6.0900000, ;
   2.0800000,    3.1700000,    3.2900000,    3.2400000,    3.4000000,    3.7400000,    4.0500000,    5.4700000,    6.4100000,    12.320000,    16.800000, ;
   3.7900000,    3.7900000,    2.8300000,    2.5600000,    2.6000000,    3.1100000,    3.4500000,    4.0800000,    5.0200000,    7.1000000,    9.1800000, ;
   3.7100000,    4.2700000,    4.6600000,    5.1000000,    5.7800000,    6.3200000,    7.0600000,    8.7500000,    11.310000,    13.870000,    16.430000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,1) = [
   4.0700000,    5.1000000,    4.3100000,    4.0400000,    3.7500000,    3.7000000,    3.6300000,    3.7100000,    3.9200000,    4.3600000,    5.2000000, ;
   4.0700000,    5.1000000,    4.3100000,    4.0400000,    3.7500000,    3.7000000,    3.6300000,    3.7100000,    3.9200000,    4.3600000,    5.2000000, ;
  0.13000000,    2.0900000,    3.2400000,    3.5600000,    3.6800000,    3.6300000,    3.9000000,    4.2700000,    4.7700000,    5.1300000,    5.9900000, ;
   1.9300000,    3.9800000,    4.5600000,    4.8800000,    4.9000000,    4.9400000,    5.0400000,    5.8200000,    6.2200000,    7.1000000,    9.2500000, ;
   2.0900000,    4.6900000,    5.5700000,    6.0100000,    6.4800000,    6.7700000,    7.2500000,    9.1300000,    10.740000,    15.430000,    20.650000, ;
   3.2000000,    5.8000000,    5.7000000,    5.5300000,    5.6900000,    6.1400000,    6.4500000,    7.2500000,    8.6600000,    10.910000,    13.160000, ;
   3.5400000,    6.0700000,    7.4300000,    8.2100000,    8.7200000,    9.5500000,    10.230000,    11.930000,    13.980000,    16.020000,    18.070000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,1,2) = [
  0.00000000,   0.40000000,   0.30000000,   0.40000000,   0.60000000,   0.70000000,   0.80000000,    1.0000000,    1.2000000,    1.6000000,    2.6000000, ;
  0.00000000,   0.40000000,   0.30000000,   0.40000000,   0.60000000,   0.70000000,   0.80000000,    1.0000000,    1.2000000,    1.6000000,    2.6000000, ;
  -1.2000000,  -0.30000000,   0.10000000,   0.20000000,   0.40000000,   0.50000000,   0.60000000,   0.90000000,    1.2000000,    1.7000000,    2.6000000, ;
 -0.70000000,   0.30000000,   0.60000000,   0.80000000,   0.90000000,    1.0000000,    1.1000000,    1.5000000,    2.0000000,    2.8000000,    4.3000000, ;
  0.10000000,   0.70000000,    1.0000000,    1.6000000,    1.8000000,    2.0000000,    2.3000000,    3.2000000,    4.4000000,    7.6000000,    11.300000, ;
 -0.10000000,   0.90000000,    1.1000000,    1.3000000,    1.3000000,    1.6000000,    1.9000000,    2.7000000,    3.5000000,    5.1000000,    5.1000000, ;
  0.10000000,    1.1000000,    1.7000000,    2.6000000,    3.0000000,    3.6000000,    4.3000000,    6.2000000,    8.3000000,    8.3000000,    8.3000000, ]; 
transmission.gear.input_torque_loss_Nm.table(:,:,2,2) = [
-0.020000000,    1.9400000,    2.2800000,    2.4500000,    2.5700000,    2.7300000,    2.8900000,    3.1400000,    3.1800000,    3.6100000,    4.5000000, ;
-0.020000000,    1.9400000,    2.2800000,    2.4500000,    2.5700000,    2.7300000,    2.8900000,    3.1400000,    3.1800000,    3.6100000,    4.5000000, ;
  -1.1800000,  -0.27000000,   0.94000000,    2.1300000,    2.3900000,    2.5500000,    2.6500000,    2.9300000,    2.8500000,    3.7400000,    4.7000000, ;
 -0.75000000,   0.24000000,    1.5800000,    2.6500000,    2.7300000,    2.8500000,    3.1500000,    3.4500000,    3.9400000,    5.1800000,    6.7200000, ;
-0.070000000,   0.54000000,    1.7300000,    3.2400000,    4.1600000,    4.4000000,    4.7900000,    5.9500000,    7.6400000,    11.100000,    15.230000, ;
 -0.26000000,   0.86000000,    2.2100000,    3.2500000,    3.6500000,    4.1100000,    4.2800000,    5.0400000,    5.8200000,    7.9000000,    7.9000000, ;
  0.10000000,    1.0400000,    2.5000000,    4.2500000,    5.2200000,    5.9500000,    6.7200000,    8.5100000,    10.720000,    10.700000,    10.700000, ]; 

transmission.gear.output_torque_loss_Nm.axis_1.breakpoints  = [    0.00000000,	   523.59878,	 ]; 
transmission.gear.output_torque_loss_Nm.axis_1.signal       = 'gb_spd_out_radps'; 
transmission.gear.output_torque_loss_Nm.table               = [    0.00000000,	  0.00000000,	 ]; 

transmission.gear.shift_duration_secs                   = 0.60000000; 

transmission.torque_converter                           = class_REVS_torque_converter;
transmission.torque_converter.pump_inertia_kgm2         = 0.038000000; 
transmission.torque_converter.turbine_inertia_kgm2      = 0.019000000; 
transmission.torque_converter.speed_ratio               = [    0.00000000,	;   0.10000000,	;   0.15000000,	;   0.20000000,	;   0.25000000,	;   0.30000000,	;   0.35000000,	;   0.40000000,	;   0.45000000,	;   0.50000000,	;   0.55000000,	;   0.60000000,	;   0.65000000,	;   0.70000000,	;   0.75000000,	;   0.80000000,	;   0.85000000,	;   0.90000000,	;   0.91000000,	;   0.92000000,	;   0.93000000,	;   0.94000000,	;   0.95000000,	;   0.96000000,	 ]; 
transmission.torque_converter.drive_torque_ratio        = [     1.8100000,	;    1.7200000,	;    1.6700000,	;    1.6300000,	;    1.5800000,	;    1.5400000,	;    1.4900000,	;    1.4500000,	;    1.4000000,	;    1.3600000,	;    1.3200000,	;    1.2700000,	;    1.2300000,	;    1.1900000,	;    1.1500000,	;    1.1000000,	;    1.0300000,	;   0.99000000,	;   0.99000000,	;   0.98000000,	;   0.99000000,	;    1.0000000,	;    1.0100000,	;    1.0000000,	 ]; 
transmission.torque_converter.drive_k_factor_rpmpsqrtNm = [     194.07000,	;    194.79276,	;    195.40140,	;    195.09708,	;    193.55646,	;    190.09483,	;    190.36111,	;    189.56227,	;    187.28939,	;    186.65222,	;    186.54761,	;    186.49055,	;    185.85338,	;    185.91044,	;    186.90899,	;    189.29599,	;    196.56161,	;    217.85444,	;    228.39149,	;    240.14581,	;    256.17012,	;    279.57416,	;    316.78668,	;    366.13392,	 ]; 
transmission.torque_converter.decel_torque_ratio        = [    0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	;   0.98000000,	 ]; 
transmission.torque_converter.decel_k_factor_rpmpsqrtNm = [     329.91900,	;    330.64176,	;    331.25040,	;    330.94608,	;    329.40546,	;    325.94383,	;    326.21011,	;    325.41127,	;    323.13839,	;    322.50122,	;    322.39661,	;    322.33955,	;    321.70238,	;    321.75944,	;    322.75799,	;    325.14499,	;    332.41061,	;    353.70344,	;    364.24049,	;    375.99481,	;    392.01912,	;    415.42316,	;    452.63568,	;    501.98292,	 ]; 
transmission.torque_converter.lockup_duration_secs      = 0.30000000; 
transmission.torque_converter.lockup_efficiency_norm    = 0.98500000; 
transmission.torque_converter.unlock_duration_secs      = 0.30000000; 

transmission.control                                            = class_REVS_AT_control;
transmission.control.line_press_rate_limit_barps                = 35.000000; 
transmission.control.line_pressure_map_bar.axis_1.breakpoints   = [    0.00000000,	   1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	 ]; 
transmission.control.line_pressure_map_bar.axis_1.signal        = 'ctrl.gear_num'; 
transmission.control.line_pressure_map_bar.axis_2.breakpoints   = [    -20.000000,	  0.00000000,	   20.000000,	   50.000000,	   100.00000,	   150.00000,	   200.00000,	   250.00000,	 ]; 
transmission.control.line_pressure_map_bar.axis_2.signal        = 'eng_load_Nm'; 
transmission.control.line_pressure_map_bar.axis_3.breakpoints   = [    0.00000000,	 0.010000000,	 ]; 
transmission.control.line_pressure_map_bar.axis_3.signal        = 'driver_brk_norm'; 
transmission.control.line_pressure_map_bar.axis_4.breakpoints   = [    0.00000000,	  0.10000000,	 ]; 
transmission.control.line_pressure_map_bar.axis_4.signal        = 'veh_spd_mps'; 
transmission.control.line_pressure_map_bar.table = [];
transmission.control.line_pressure_map_bar.table(:,:,1,1) = [
   5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000, ;
   10.000000,    8.5000000,    10.000000,    12.000000,    14.000000,    16.000000,    18.000000,    20.000000, ;
   5.0000000,    4.5000000,    5.0000000,    7.0000000,    8.5000000,    10.000000,    13.500000,    18.000000, ;
   5.0000000,    4.5000000,    5.0000000,    6.0000000,    7.0000000,    8.5000000,    10.500000,    13.000000, ;
   4.5000000,    4.0000000,    4.5000000,    5.0000000,    6.0000000,    7.5000000,    10.500000,    13.500000, ;
   5.0000000,    5.0000000,    5.0000000,    6.0000000,    7.5000000,    9.5000000,    13.000000,    16.500000, ;
   4.5000000,    4.0000000,    4.5000000,    5.0000000,    6.0000000,    7.5000000,    10.500000,    13.500000, ]; 
transmission.control.line_pressure_map_bar.table(:,:,2,1) = [
   3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000, ;
   3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000, ;
   3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000, ;
   3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000, ;
   3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000, ;
   3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000, ;
   3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000,    3.5000000, ]; 
transmission.control.line_pressure_map_bar.table(:,:,1,2) = [
   5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000, ;
   10.000000,    8.5000000,    10.000000,    12.000000,    14.000000,    16.000000,    18.000000,    20.000000, ;
   5.0000000,    4.5000000,    5.0000000,    7.0000000,    8.5000000,    10.000000,    13.500000,    18.000000, ;
   5.0000000,    4.5000000,    5.0000000,    6.0000000,    7.0000000,    8.5000000,    10.500000,    13.000000, ;
   4.5000000,    4.0000000,    4.5000000,    5.0000000,    6.0000000,    7.5000000,    10.500000,    13.500000, ;
   5.0000000,    5.0000000,    5.0000000,    6.0000000,    7.5000000,    9.5000000,    13.000000,    16.500000, ;
   4.5000000,    4.0000000,    4.5000000,    5.0000000,    6.0000000,    7.5000000,    10.500000,    13.500000, ]; 
transmission.control.line_pressure_map_bar.table(:,:,2,2) = [
   5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000,    5.0000000, ;
   10.000000,    8.5000000,    10.000000,    12.000000,    14.000000,    16.000000,    18.000000,    20.000000, ;
   5.0000000,    4.5000000,    5.0000000,    7.0000000,    8.5000000,    10.000000,    13.500000,    18.000000, ;
   5.0000000,    4.5000000,    5.0000000,    6.0000000,    7.0000000,    8.5000000,    10.500000,    13.000000, ;
   4.5000000,    4.0000000,    4.5000000,    5.0000000,    6.0000000,    7.5000000,    10.500000,    13.500000, ;
   5.0000000,    5.0000000,    5.0000000,    6.0000000,    7.5000000,    9.5000000,    13.000000,    16.500000, ;
   4.5000000,    4.0000000,    4.5000000,    5.0000000,    6.0000000,    7.5000000,    10.500000,    13.500000, ]; 

transmission.control.auto_neutral_enable                = 0; 
transmission.control.auto_neutral_delay_secs            = 0.00000000; 
transmission.control.auto_neutral_warmup_condition      = '0'; 
transmission.control.auto_neutral_warmup_temp_degC      = 50.000000; 
transmission.control.auto_neutral_warmup_duration_secs  = 100.00000; 

transmission.thermal.temperature_degC           =     90.000000; 
transmission.pump_loss_Nm.axis_1.breakpoints    = [     5.0000000,	   15.000000,	 ]; 
transmission.pump_loss_Nm.axis_1.signal         = 'gb_line_press_bar'; 
transmission.pump_loss_Nm.axis_2.breakpoints    = [     52.359878,	   523.59878,	 ]; 
transmission.pump_loss_Nm.axis_2.signal         = 'tc_spd_in_radps'; 
transmission.pump_loss_Nm.axis_3.breakpoints    = [     35.000000,	   100.00000,	 ]; 
transmission.pump_loss_Nm.axis_3.signal         = 'trans_temp_degC'; 
transmission.pump_loss_Nm.table(:,:,1) = [
   5.3000000,    5.3000000, ;
   5.3000000,    5.3000000, ]; 
transmission.pump_loss_Nm.table(:,:,2) = [
   3.8000000,    3.8000000, ;
   3.8000000,    3.8000000, ]; 

transmission.tcc_strategy.always_lock_gear              = 4.0000000; 
transmission.tcc_strategy.always_unlock_gear            = 2.0000000; 
transmission.tcc_strategy.downshift_unlock_condition    = '0'; 
transmission.tcc_strategy.lock_condition                = '(@gb_spd_out_radps > @table_lock_spd && @trans_curr_gear > transmission.tcc_strategy.always_unlock_gear ) || @trans_curr_gear >= transmission.tcc_strategy.always_lock_gear '; 
transmission.tcc_strategy.lock_table.axis_1.breakpoints = [     1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	 ]; 
transmission.tcc_strategy.lock_table.axis_1.signal      = 'ctrl.gear_num'; 
transmission.tcc_strategy.lock_table.axis_2.breakpoints = [    0.00000000,	   1.0000000,	 ]; 
transmission.tcc_strategy.lock_table.axis_2.signal      = 'eng_load_norm'; 
transmission.tcc_strategy.lock_table.table = [
   1047.1976,    1047.1976, ;
   1047.1976,    1047.1976, ;
   167.55161,    167.55161, ;
  0.00000000,   0.00000000, ;
  0.00000000,   0.00000000, ;
  0.00000000,   0.00000000, ]; 
transmission.tcc_strategy.lockup_allowed                    = 1; 
transmission.tcc_strategy.lockup_delay_secs                 = 0.50000000; 
transmission.tcc_strategy.lockup_duration_secs              = 0.50000000; 
transmission.tcc_strategy.unlock_condition                  = '(@gb_spd_out_radps < @table_unlock_spd && @trans_curr_gear < transmission.tcc_strategy.always_lock_gear ) || @trans_curr_gear <= transmission.tcc_strategy.always_unlock_gear'; 
transmission.tcc_strategy.unlock_table.axis_1.breakpoints   = [     1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	 ]; 
transmission.tcc_strategy.unlock_table.axis_1.signal        = 'ctrl.gear_num'; 
transmission.tcc_strategy.unlock_table.axis_2.breakpoints   = [    0.00000000,	   1.0000000,	 ]; 
transmission.tcc_strategy.unlock_table.axis_2.signal        = 'eng_load_norm'; 
transmission.tcc_strategy.unlock_table.table = [
   31.733259,    31.733259, ;
   31.733259,    31.733259, ;
   3.8079911,    3.8079911, ;
  0.00000000,   0.00000000, ;
  0.00000000,   0.00000000, ;
  0.00000000,   0.00000000, ]; 
transmission.tcc_strategy.upshift_unlock_condition          =  '0'; 

%%
transmission_gear_select                                    = enum_transmission_gear_select.ALPHAshift;
transmission.gear_strategy                                  = class_REVS_ALPHAshift;
transmission.gear_strategy.launch_gear_num                  = 1.0000000; 
transmission.gear_strategy.restrict_skip_shifts             = 1; 
transmission.gear_strategy.restrict_shift_parity            = 0; 
transmission.gear_strategy.min_speed_radps                  = [    0.00000000,	   62.831853,	   86.393798,	   115.19173,	   115.19173,	   115.19173,	   115.19173,	 ]; 
transmission.gear_strategy.min_speed_shift_increment        = [     1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	 ]; 
transmission.gear_strategy.max_speed_radps                  = [    0.00000000,	   628.31853,	   628.31853,	   628.31853,	   628.31853,	   628.31853,	   628.31853,	 ]; 
transmission.gear_strategy.max_speed_shift_increment        = [     1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	 ]; 
transmission.gear_strategy.downshift_delay_secs             = [    0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	 ]; 
transmission.gear_strategy.downshift_commit_secs            = [    0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	 ]; 
transmission.gear_strategy.downshift_max_speed_radps        = [    0.00000000,	   534.07075,	   534.07075,	   534.07075,	   534.07075,	   534.07075,	   534.07075,	 ]; 
transmission.gear_strategy.disable_cost_saving_downshifts   = 1; 
transmission.gear_strategy.upshift_min_speed_radps          = [    0.00000000,	   62.831853,	   115.19173,	   125.66371,	   125.66371,	   125.66371,	   125.66371,	 ]; 
transmission.gear_strategy.upshift_delay_secs               = [    0.00000000,	  0.10000000,	  0.10000000,	  0.12000000,	  0.12000000,	  0.12000000,	  0.12000000,	 ]; 
transmission.gear_strategy.upshift_commit_secs              = [     1.3000000,	   1.3000000,	   1.3000000,	   1.3000000,	   1.3000000,	   1.3000000,	   1.3000000,	 ]; 
transmission.gear_strategy.upshift_min_torque_reserve_ratio = [     1.1000000,	   1.1000000,	   1.1000000,	   1.1000000,	   1.1000000,	   1.1000000,	   1.1000000,	 ]; 
transmission.gear_strategy.kickdown_trigger_ratio           = [     1.5000000,	   1.5000000,	   1.5000000,	   1.5000000,	   1.5000000,	   1.5000000,	   1.5000000,	 ]; 
transmission.gear_strategy.kickdown_delay_secs              = [    0.50000000,	  0.50000000,	  0.50000000,	  0.50000000,	  0.50000000,	  0.50000000,	  0.50000000,	 ]; 
transmission.gear_strategy.kickdown_shift_increment         = [     1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	 ]; 
transmission.gear_strategy.kickdown_min_gear                = 1.0000000; 
transmission.gear_strategy.kickdown_max_increment           = 2.0000000; 
transmission.gear_strategy.use_engine_speed_mask            = [    0.00000000,	   1.0000000,	   1.0000000,	   1.0000000,	  0.00000000,	  0.00000000,	  0.00000000,	 ]; 
transmission.gear_strategy.max_input_torque_curve_Nm        = [  2.2204460e-16,	   105.00000,	   169.00000,	   197.00000,	   202.00000,	   209.00000,	   218.00000,	   208.00000,	   179.00000,	   170.00000,	2.2204460e-16,	 ]; 
transmission.gear_strategy.max_input_torque_speeds_radps    = [    0.00000000,	   64.402649,	   98.750729,	   160.22123,	   195.61650,	   257.61060,	   418.77430,	   532.49995,	   659.31558,	   691.46454,	   711.98962,	 ]; 
transmission.gear_strategy.required_cost_benefit_ratio      = [     1.0000000,	   1.0300000,	   1.0300000,	   1.0200000,	   1.0200000,	   1.0200000,	   1.0200000,	 ]; 
transmission.gear_strategy.cost_map_speed_radps             = [     41.887900,	   62.831900,	   83.775800,	   104.72000,	   125.66400,	   146.60800,	   167.55200,	   188.49600,	   209.44000,	   230.38300,	   251.32700,	   272.27100,	   293.21500,	   314.15900,	   335.10300,	   356.04700,	   376.99100,	   397.93500,	   418.87900,	   439.82300,	   460.76700,	   481.71100,	   502.65500,	   523.59900,	   544.54300,	   565.48700,	   586.43100,	   607.37500,	   628.31900,	   649.26200,	   670.20600,	   691.15000,	   712.09400,	 ]; 
transmission.gear_strategy.cost_map_torque_Nm               = [    -60.000000,	  -50.000000,	  -40.000000,	  -30.000000,	  -20.000000,	  -10.000000,	  0.00000000,	   10.000000,	   20.000000,	   30.000000,	   40.000000,	   50.000000,	   60.000000,	   70.000000,	   80.000000,	   90.000000,	   100.00000,	   110.00000,	   120.00000,	   130.00000,	   140.00000,	   150.00000,	   160.00000,	   170.00000,	   180.00000,	   190.00000,	   200.00000,	   210.00000,	   220.00000,	   230.00000,	   240.00000,	   250.00000,	 ]; 
transmission.gear_strategy.cost_map = [
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.15382300,   0.88267916,    1.6147373,    2.3480044, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.52588836,    1.2842107,    2.0911812,    2.9405948,    3.8267056,    4.7435630,    5.6851046,    6.6455356,    7.6196260,    8.6027690,    9.5909714,    10.581058, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,  0.044546622,   0.21374896,   0.38325628,   0.55870494,   0.74904114,   0.96913546,    1.2351416,    1.5641291,    1.9707428,    2.4634010,    3.0438262,    3.7073610,    4.4531498,    5.2771676,    6.1697334,    7.1228884,    8.1324636,    9.1949794,    10.305657,    11.457819,    12.643384,    13.853909,    15.081601,    16.319886,    17.563523,    18.808873, ;
  0.92643270,    1.0009730,    1.1742921,    1.4569560,    1.6794670,    1.8913970,    2.1980908,    2.5707132,    2.9673142,    3.3654966,    3.7648240,    4.1793466,    4.6293666,    5.1339102,    5.7076016,    6.3592678,    7.0912678,    7.8988302,    8.7750104,    9.7158084,    10.720363,    11.790918,    12.930081,    14.138650,    15.414783,    16.753491,    18.146521,    19.582837,    21.049910,    22.535446,    24.029498,    25.525758,    27.021746, ;
   2.9751472,    3.2331122,    3.4513876,    3.6130080,    3.7534500,    3.9832862,    4.4322632,    4.9982758,    5.6136654,    6.2407534,    6.8622322,    7.4975052,    8.1781894,    8.9245152,    9.7501976,    10.659383,    11.646532,    12.696838,    13.791775,    14.923303,    16.105408,    17.356053,    18.686090,    20.098822,    21.592720,    23.162796,    24.800644,    26.493460,    28.224196,    29.973070,    31.722520,    33.465548,    35.205096, ;
   4.5254086,    4.9599440,    5.2251340,    5.3440466,    5.5474754,    5.8927610,    6.4835518,    7.2204398,    8.0452650,    8.9044768,    9.7531774,    10.615113,    11.530673,    12.521784,    13.607050,    14.785257,    16.038988,    17.348688,    18.679382,    20.005116,    21.380932,    22.835816,    24.378724,    26.011032,    27.730790,    29.534086,    31.415416,    33.364586,    35.360730,    37.376008,    39.378966,    41.362930,    43.345114, ;
   1.1284349,    1.2653039,    1.3320926,    1.3933184,    1.4825737,    1.6220338,    1.8226223,    2.0507074,    2.2935304,    2.5406312,    2.7859938,    3.0351409,    3.2967884,    3.5776769,    3.8812547,    4.2062835,    4.5467021,    4.8949481,    5.2465992,    5.6030067,    5.9710047,    6.3553945,    6.7583477,    7.1803061,    7.6211570,    8.0805006,    8.5574364,    9.0518037,    9.5571313,    10.065767,    10.573577,    11.079355,    11.584157, ;
  0.63581197,   0.72251793,   0.77484984,   0.84210943,   0.93520556,    1.0601422,    1.2098799,    1.3693178,    1.5371157,    1.7061314,    1.8746880,    2.0461444,    2.2252628,    2.4157123,    2.6189510,    2.8336706,    3.0564910,    3.2848613,    3.5177612,    3.7557621,    4.0004548,    4.2535546,    4.5160235,    4.7874739,    5.0679059,    5.3583943,    5.6576703,    5.9651863,    6.2786233,    6.5954266,    6.9136134,    7.2313579,    7.5481102, ;
  0.44259521,   0.50453491,   0.56798847,   0.64313782,   0.74083959,   0.85617551,   0.97904650,    1.1053973,    1.2388078,    1.3738979,    1.5094853,    1.6480391,    1.7935173,    1.9481778,    2.1111864,    2.2820454,    2.4598541,    2.6434655,    2.8319320,    3.0247569,    3.2220335,    3.4247445,    3.6336480,    3.8481215,    4.0675152,    4.2922940,    4.5221286,    4.7564858,    4.9946473,    5.2355986,    5.4781563,    5.7204990,    5.9622184, ;
  0.33944219,   0.39779640,   0.47497932,   0.55955961,   0.65437208,   0.75714640,   0.86321203,   0.97147807,    1.0849580,    1.2001222,    1.3163114,    1.4362761,    1.5627045,    1.6959424,    1.8361766,    1.9836449,    2.1383371,    2.2993716,    2.4653470,    2.6349062,    2.8072070,    2.9831722,    3.1628836,    3.3463173,    3.5334936,    3.7242478,    3.9180866,    4.1145212,    4.3135138,    4.5140221,    4.7150811,    4.9157552,    5.1158091, ;
  0.30752392,   0.38229514,   0.47602016,   0.57344101,   0.67440868,   0.77799603,   0.88412062,   0.99298238,    1.1074934,    1.2237239,    1.3409239,    1.4613481,    1.5875489,    1.7209555,    1.8623231,    2.0112200,    2.1680429,    2.3325481,    2.5027874,    2.6760750,    2.8507654,    3.0270941,    3.2062079,    3.3891600,    3.5762810,    3.7670641,    3.9603395,    4.1552533,    4.3510049,    4.5469603,    4.7427213,    4.9374044,    5.1305598, ;
  0.29910322,   0.40545237,   0.51497802,   0.62530802,   0.73641750,   0.84890768,   0.96359041,    1.0804121,    1.2029756,    1.3279632,    1.4534395,    1.5819277,    1.7168637,    1.8602723,    2.0129909,    2.1740716,    2.3423584,    2.5184629,    2.7011894,    2.8868054,    3.0728398,    3.2595327,    3.4491642,    3.6440174,    3.8439896,    4.0479791,    4.2543123,    4.4615779,    4.6683295,    4.8736033,    5.0773366,    5.2795823,    5.4808456, ;
  0.31728472,   0.43668304,   0.55610932,   0.67543364,   0.79513714,   0.91615562,    1.0390604,    1.1642762,    1.2969494,    1.4312515,    1.5649873,    1.7013366,    1.8444035,    1.9971135,    2.1602383,    2.3320976,    2.5111485,    2.6973173,    2.8888669,    3.0837026,    3.2802282,    3.4781167,    3.6798714,    3.8874170,    4.1002850,    4.3167695,    4.5351112,    4.7546077,    4.9735519,    5.1908978,    5.4059295,    5.6186101,    5.8298010, ;
  0.34785601,   0.47376426,   0.59946380,   0.72499060,   0.85200239,   0.98161392,    1.1140173,    1.2494040,    1.3913257,    1.5344103,    1.6771347,    1.8221433,    1.9731537,    2.1332079,    2.3036641,    2.4834182,    2.6719954,    2.8680258,    3.0693596,    3.2737460,    3.4799445,    3.6898356,    3.9043100,    4.1236068,    4.3477011,    4.5746332,    4.8035706,    5.0352988,    5.2690886,    5.5028419,    5.7336643,    5.9620496,    6.1889663, ;
  0.38669613,   0.51810146,   0.64925968,   0.78054289,   0.91507610,    1.0539397,    1.1968814,    1.3433421,    1.4941108,    1.6464779,    1.8000135,    1.9554314,    2.1152662,    2.2826697,    2.4602033,    2.6482283,    2.8462520,    3.0529276,    3.2659930,    3.4823274,    3.7010301,    3.9242066,    4.1522712,    4.3837595,    4.6170959,    4.8533048,    5.0938336,    5.3398889,    5.5921916,    5.8485328,    6.1052456,    6.3607833,    6.6149496, ;
  0.43560334,   0.57380863,   0.71178220,   0.85091163,   0.99511069,    1.1460080,    1.3008755,    1.4593210,    1.6216755,    1.7865226,    1.9532844,    2.1221145,    2.2946711,    2.4729404,    2.6606412,    2.8605433,    3.0709027,    3.2892161,    3.5141561,    3.7459976,    3.9821758,    4.2215140,    4.4639831,    4.7095243,    4.9585498,    5.2114307,    5.4686399,    5.7346619,    6.0139334,    6.3048708,    6.6023234,    6.9018791,    7.2029856, ;
  0.48665739,   0.63199965,   0.77740983,   0.92478132,    1.0790911,    1.2409612,    1.4083142,    1.5795229,    1.7540389,    1.9307533,    2.1095429,    2.2916381,    2.4790390,    2.6719740,    2.8719310,    3.0813266,    3.3015881,    3.5307499,    3.7683993,    4.0138220,    4.2644124,    4.5168011,    4.7720539,    5.0335461,    5.3016556,    5.5734927,    5.8502151,    6.1422393,    6.4568296,    6.7906489,    7.1390188,    7.5019485,    7.8735270, ;
  0.53837142,   0.69152415,   0.84499137,    1.0011770,    1.1656499,    1.3375558,    1.5159924,    1.6995944,    1.8869090,    2.0762867,    2.2672177,    2.4622928,    2.6637765,    2.8724920,    3.0882810,    3.3095204,    3.5362431,    3.7743902,    4.0244434,    4.2820150,    4.5412518,    4.8045687,    5.0770231,    5.3581001,    5.6443635,    5.9379067,    6.2471998,    6.5787340,    6.9360976,    7.3262612,    7.7421675,    8.1854814,    8.6448643, ;
  0.58908112,   0.75161820,   0.91458531,    1.0801223,    1.2534236,    1.4342646,    1.6223329,    1.8170511,    2.0172700,    2.2191933,    2.4219386,    2.6288405,    2.8437903,    3.0678010,    3.2994115,    3.5351199,    3.7753827,    4.0224385,    4.2783532,    4.5416088,    4.8115063,    5.0912502,    5.3825631,    5.6851786,    5.9984696,    6.3267732,    6.6781728,    7.0651672,    7.4900941,    7.9612825,    8.4579128,    8.9789269,    9.5105880, ;
  0.63624787,   0.81067146,   0.98543774,    1.1611246,    1.3422469,    1.5312904,    1.7290234,    1.9360414,    2.1492669,    2.3630576,    2.5779857,    2.7961800,    3.0209449,    3.2563176,    3.5028637,    3.7564725,    4.0137926,    4.2725932,    4.5319421,    4.7982008,    5.0792670,    5.3772297,    5.6908765,    6.0219913,    6.3730173,    6.7455621,    7.1539411,    7.6181285,    8.1372198,    8.7051450,    9.2825624,    9.8547687,    10.418775, ;
  0.67614008,   0.86462967,    1.0525018,    1.2386225,    1.4301609,    1.6299829,    1.8390827,    2.0580664,    2.2818220,    2.5066473,    2.7337573,    2.9651266,    3.2027217,    3.4477928,    3.7051250,    3.9741477,    4.2467274,    4.5160132,    4.7848800,    5.0615350,    5.3530980,    5.6663800,    6.0068699,    6.3744366,    6.7686789,    7.2010903,    7.6846102,    8.2369886,    8.8423447,    9.4783068,    10.106676,    10.708696,    11.287802, ;
  0.70409255,   0.90786164,    1.1098536,    1.3095245,    1.5172935,    1.7323771,    1.9546319,    2.1840427,    2.4167391,    2.6525872,    2.8924767,    3.1373970,    3.3899915,    3.6492122,    3.9150695,    4.1909167,    4.4719281,    4.7537738,    5.0393565,    5.3328773,    5.6395037,    5.9708025,    6.3402588,    6.7471134,    7.2017214,    7.7157293,    8.2875219,    8.9129433,    9.5638021,    10.217057,    10.854297,    11.464219,    12.060900, ;
  0.71723608,   0.93944226,    1.1596715,    1.3798124,    1.6081044,    1.8414333,    2.0780125,    2.3179424,    2.5612728,    2.8096248,    3.0632814,    3.3221733,    3.5894980,    3.8621115,    4.1378017,    4.4153197,    4.7003607,    4.9970982,    5.3012353,    5.6138798,    5.9431122,    6.3021889,    6.7072788,    7.1666224,    7.6975055,    8.3030495,    8.9595544,    9.6298159,    10.286012,    10.920710,    11.536099,    12.141603,    12.748675, ;
  0.71649915,   0.96192111,    1.2054431,    1.4513328,    1.7044874,    1.9597464,    2.2132793,    2.4667069,    2.7250583,    2.9885170,    3.2561811,    3.5282116,    3.8072740,    4.0908555,    4.3747849,    4.6576624,    4.9501126,    5.2581347,    5.5767902,    5.9117586,    6.2742155,    6.6768729,    7.1396365,    7.6729434,    8.2913517,    8.9737925,    9.6796185,    10.363216,    11.006061,    11.613911,    12.205537,    12.799355,    13.399035, ;
  0.71471982,   0.98146449,    1.2508787,    1.5249919,    1.8045549,    2.0846502,    2.3591279,    2.6321040,    2.9076897,    3.1861210,    3.4647431,    3.7486794,    4.0399714,    4.3356084,    4.6302950,    4.9253374,    5.2268842,    5.5383923,    5.8679594,    6.2294863,    6.6370550,    7.1074612,    7.6541247,    8.2798261,    8.9730353,    9.7025933,    10.424147,    11.101953,    11.720246,    12.307006,    12.882927,    13.464878,    14.054496, ;
  0.71380081,    1.0063658,    1.3006478,    1.5995735,    1.9025689,    2.2051767,    2.5034631,    2.8005281,    3.0969264,    3.3906393,    3.6833758,    3.9813108,    4.2877075,    4.5987545,    4.9079778,    5.2127329,    5.5157840,    5.8289728,    6.1718654,    6.5660157,    7.0326725,    7.5900614,    8.2296740,    8.9362216,    9.6842709,    10.428353,    11.134972,    11.797823,    12.411041,    12.999826,    13.578125,    14.156974,    14.740317, ;
  0.72421344,    1.0397294,    1.3563136,    1.6757632,    1.9976065,    2.3187935,    2.6385893,    2.9574720,    3.2750756,    3.5911607,    3.9070441,    4.2251022,    4.5479509,    4.8718727,    5.1907643,    5.5007775,    5.8069506,    6.1273289,    6.4856965,    6.9098954,    7.4425154,    8.0812085,    8.8102101,    9.5773235,    10.346801,    11.091903,    11.795550,    12.460657,    13.090994,    13.697267,    14.288238,    14.873604,    15.459575, ;
  0.74519030,    1.0812006,    1.4175035,    1.7545647,    2.0919641,    2.4290091,    2.7664836,    3.1049931,    3.4453497,    3.7871159,    4.1284910,    4.4677141,    4.8056581,    5.1392734,    5.4642965,    5.7805829,    6.0969606,    6.4306452,    6.8078146,    7.2536037,    7.8351957,    8.5214493,    9.2971821,    10.113374,    10.929149,    11.712851,    12.446726,    13.133261,    13.782493,    14.404436,    15.009583,    15.606530,    16.202263, ;
  0.77419562,    1.1283618,    1.4824446,    1.8360989,    2.1883502,    2.5390511,    2.8915319,    3.2485492,    3.6123644,    3.9787293,    4.3434650,    4.7026473,    5.0550003,    5.3977327,    5.7294414,    6.0554934,    6.3835847,    6.7309556,    7.1301765,    7.6159207,    8.2217342,    8.9512262,    9.7711973,    10.634970,    11.494475,    12.321555,    13.092123,    13.806045,    14.474505,    15.113214,    15.734380,    16.346435,    16.956544, ;
  0.80788916,    1.1783298,    1.5483287,    1.9170372,    2.2833493,    2.6490194,    3.0175992,    3.3937737,    3.7788767,    4.1663194,    4.5510478,    4.9287276,    5.2951771,    5.6475199,    5.9896068,    6.3262539,    6.6640492,    7.0318666,    7.4638079,    7.9932379,    8.6364239,    9.3982156,    10.256052,    11.161641,    12.063224,    12.926458,    13.724482,    14.465824,    15.159448,    15.819717,    16.457861,    17.085818,    17.713994, ;
  0.84319980,    1.2289901,    1.6141546,    1.9977385,    2.3786942,    2.7602918,    3.1470984,    3.5430340,    3.9468079,    4.3530508,    4.7559002,    5.1496246,    5.5289217,    5.8918351,    6.2420907,    6.5849019,    6.9385473,    7.3344027,    7.8054644,    8.3781466,    9.0651124,    9.8654115,    10.757408,    11.694471,    12.625785,    13.515424,    14.347113,    15.120778,    15.841744,    16.523024,    17.179537,    17.826310,    18.471686, ]; 
